implementation module controldefaccess


import	StdInt
import	commondef, StdControlDef


//	Access rules to ControlAttributes:

ControlAttributesHaveThisId :: !Id ![ControlAttribute .ps] -> Bool
ControlAttributesHaveThisId id atts
	| hasId
	= id==getcontrolid idAtt
	= False
where
	(hasId,idAtt)	= Select iscontrolid (ControlId id) atts


sameControlAttribute :: !(ControlAttribute .ps) !(ControlAttribute .ps) -> Bool
sameControlAttribute (ControlId				_) att = iscontrolid att
sameControlAttribute (ControlPos			_) att = iscontrolpos att
sameControlAttribute (ControlSize			_) att = iscontrolsize att
sameControlAttribute (ControlMinimumSize	_) att = iscontrolminimumsize att
sameControlAttribute (ControlResize			_) att = iscontrolresize att
sameControlAttribute (ControlSelectState	_) att = iscontrolselectstate att
sameControlAttribute  ControlHide			   att = iscontrolhide att
sameControlAttribute (ControlFunction		_) att = iscontrolfunction att
sameControlAttribute (ControlModsFunction	_) att = iscontrolmodsfunction att
sameControlAttribute (ControlMouse		_ _ _) att = iscontrolmouse att
sameControlAttribute (ControlKeyboard	_ _ _) att = iscontrolkeyboard att
sameControlAttribute (ControlItemSpace	_	_) att = iscontrolitemspace att
sameControlAttribute (ControlHMargin	_	_) att = iscontrolhmargin att
sameControlAttribute (ControlVMargin	_	_) att = iscontrolvmargin att
sameControlAttribute (ControlLook			_) att = iscontrollook att
sameControlAttribute (ControlViewDomain		_) att = iscontrolviewdomain att
sameControlAttribute (ControlOrigin			_) att = iscontrolorigin att
sameControlAttribute (ControlHScroll		_) att = iscontrolhscroll att
sameControlAttribute (ControlVScroll		_) att = iscontrolvscroll att


iscontrolid				:: !(ControlAttribute .ps) -> Bool
iscontrolid				(ControlId _)			= True
iscontrolid				_						= False

iscontrolpos			:: !(ControlAttribute .ps) -> Bool
iscontrolpos			(ControlPos _)			= True
iscontrolpos			_						= False

iscontrolsize			:: !(ControlAttribute .ps) -> Bool
iscontrolsize			(ControlSize _)			= True
iscontrolsize			_						= False

iscontrolminimumsize	:: !(ControlAttribute .ps) -> Bool
iscontrolminimumsize	(ControlMinimumSize _)	= True
iscontrolminimumsize	_						= False

iscontrolresize			:: !(ControlAttribute .ps) -> Bool
iscontrolresize			(ControlResize _)		= True
iscontrolresize			_						= False

iscontrolselectstate	:: !(ControlAttribute .ps) -> Bool
iscontrolselectstate	(ControlSelectState _)	= True
iscontrolselectstate	_						= False

iscontrolhide			:: !(ControlAttribute .ps) -> Bool
iscontrolhide			ControlHide				= True
iscontrolhide			_						= False

iscontrolfunction		:: !(ControlAttribute .ps) -> Bool
iscontrolfunction		(ControlFunction _)		= True
iscontrolfunction		_						= False

iscontrolmodsfunction	:: !(ControlAttribute .ps) -> Bool
iscontrolmodsfunction	(ControlModsFunction _)	= True
iscontrolmodsfunction	_						= False

iscontrolmouse			:: !(ControlAttribute .ps) -> Bool
iscontrolmouse			(ControlMouse _ _ _)	= True
iscontrolmouse			_						= False

iscontrolkeyboard		:: !(ControlAttribute .ps) -> Bool
iscontrolkeyboard		(ControlKeyboard _ _ _)	= True
iscontrolkeyboard		_						= False

iscontrolitemspace		:: !(ControlAttribute .ps) -> Bool
iscontrolitemspace		(ControlItemSpace _ _)	= True
iscontrolitemspace		_						= False

iscontrolhmargin		:: !(ControlAttribute .ps) -> Bool
iscontrolhmargin		(ControlHMargin _ _)	= True
iscontrolhmargin		_						= False

iscontrolvmargin		:: !(ControlAttribute .ps) -> Bool
iscontrolvmargin		(ControlVMargin _ _)	= True
iscontrolvmargin		_						= False

iscontrollook			:: !(ControlAttribute .ps) -> Bool
iscontrollook			(ControlLook _)			= True
iscontrollook			_						= False

iscontrolviewdomain		:: !(ControlAttribute .ps) -> Bool
iscontrolviewdomain		(ControlViewDomain _)	= True
iscontrolviewdomain		_						= False

iscontrolorigin			:: !(ControlAttribute .ps) -> Bool
iscontrolorigin			(ControlOrigin _)		= True
iscontrolorigin			_						= False

iscontrolhscroll		:: !(ControlAttribute .ps) -> Bool
iscontrolhscroll		(ControlHScroll _)		= True
iscontrolhscroll		_						= False

iscontrolvscroll		:: !(ControlAttribute .ps) -> Bool
iscontrolvscroll		(ControlVScroll _)		= True
iscontrolvscroll		_						= False


getcontrolid :: !(ControlAttribute .ps) -> Id
getcontrolid (ControlId id) = id

getcontrolpos :: !(ControlAttribute .ps) -> ItemPos
getcontrolpos (ControlPos itemPos) = itemPos

getcontrolsize :: !(ControlAttribute .ps) -> Size
getcontrolsize (ControlSize size) = size

getcontrolminimumsize :: !(ControlAttribute .ps) -> Size
getcontrolminimumsize (ControlMinimumSize size) = size

getcontrolresize :: !(ControlAttribute .ps) -> ControlResizeFunction
getcontrolresize (ControlResize f) = f

getcontrolselectstate :: !(ControlAttribute .ps) -> SelectState
getcontrolselectstate (ControlSelectState s) = s

getcontrolfunction :: !(ControlAttribute .ps) -> IOFunction .ps
getcontrolfunction (ControlFunction f) = f

getcontrolmodsfunction :: !(ControlAttribute .ps) -> ModsIOFunction .ps
getcontrolmodsfunction (ControlModsFunction f) = f

getcontrolmouseinfo :: !(ControlAttribute .ps) -> (MouseStateFilter,SelectState,MouseFunction .ps)
getcontrolmouseinfo (ControlMouse filter s f) = (filter,s,f)

getcontrolkeyboardinfo :: !(ControlAttribute .ps) -> (KeyboardStateFilter,SelectState,KeyboardFunction  .ps)
getcontrolkeyboardinfo (ControlKeyboard filter s f) = (filter,s,f)

getcontrolitemspace :: !(ControlAttribute .ps) -> (Int,Int)
getcontrolitemspace (ControlItemSpace hspace vspace) = (hspace,vspace)

getcontrolhmargin :: !(ControlAttribute .ps) -> (Int,Int)
getcontrolhmargin (ControlHMargin left right) = (left,right)

getcontrolvmargin :: !(ControlAttribute .ps) -> (Int,Int)
getcontrolvmargin (ControlVMargin top bottom) = (top,bottom)

getcontrollook :: !(ControlAttribute .ps) -> Look
getcontrollook (ControlLook f) = f

getcontroldomain :: !(ControlAttribute .ps) -> ViewDomain
getcontroldomain (ControlViewDomain pd) = pd

getcontrolorigin :: !(ControlAttribute .ps) -> Point
getcontrolorigin (ControlOrigin p) = p

getcontrolhscrollfunction :: !(ControlAttribute .ps) -> ScrollFunction
getcontrolhscrollfunction (ControlHScroll f) = f

getcontrolvscrollfunction :: !(ControlAttribute .ps) -> ScrollFunction
getcontrolvscrollfunction (ControlVScroll f) = f
